<?php

// --- PHP PROXY (TIDAK BERUBAH) ---
if (isset($_GET['action'])) {
    header('Content-Type: application/json');
    header('Access-Control-Allow-Origin: *');
    header('Cache-Control: no-cache, no-store, must-revalidate');
    $action = $_GET['action'];
    
    function fetchBingX($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }

    if ($action == 'ticker') {
        echo fetchBingX("https://open-api.bingx.com/openApi/swap/v2/quote/ticker");
    } 
    elseif ($action == 'history') {
        $symbol = $_GET['symbol'];
        $interval = $_GET['interval'];
        $url = "https://open-api.bingx.com/openApi/swap/v3/quote/klines?symbol={$symbol}&interval={$interval}&limit=50"; 
        echo fetchBingX($url);
    }
    exit; 
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BingX SMC Sniper Pro</title>
    <style>
        /* BASE STYLE */
        body { font-family: 'Segoe UI', Roboto, sans-serif; background-color: #0b0e11; color: #e0e0e0; margin: 0; padding: 20px; }
        
        h1 { text-align: center; color: #fff; margin: 10px 0 5px 0; font-weight: 200; letter-spacing: 2px; text-transform: uppercase; font-size: 1.5rem; }
        .config-info { text-align: center; font-size: 0.8em; color: #555; margin-bottom: 20px; }
        .update-info { text-align: center; font-size: 0.8em; color: #4caf50; margin-bottom: 15px; font-family: monospace; }
        
        /* BTC DASHBOARD */
        .btc-hero {
            background: linear-gradient(145deg, #161a1e, #0d1014);
            border: 1px solid #2a2e35; border-radius: 12px; padding: 20px;
            max-width: 900px; margin: 0 auto 30px auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
            display: flex; justify-content: space-between; align-items: center;
            position: relative; overflow: hidden;
        }
        .btc-hero::before {
            content: ''; position: absolute; top: -50%; left: -50%; width: 200%; height: 200%;
            background: radial-gradient(circle, rgba(247, 147, 26, 0.05) 0%, rgba(0,0,0,0) 60%); pointer-events: none;
        }
        .hero-left { display: flex; align-items: center; gap: 20px; z-index: 1; }
        .btc-logo { width: 60px; height: 60px; filter: drop-shadow(0 0 10px rgba(247, 147, 26, 0.5)); animation: float 3s ease-in-out infinite; }
        .btc-price-group h2 { margin: 0; color: #888; font-size: 1rem; letter-spacing: 1px; }
        .btc-price-group h1 { margin: 0; font-size: 2.5rem; font-weight: 700; font-family: 'Courier New', monospace; text-shadow: 0 0 20px rgba(0,0,0,0.5); }
        .btc-change { font-size: 1rem; font-weight: bold; padding: 2px 8px; border-radius: 4px; display: inline-block; margin-top: 5px; }
        .hero-right { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; z-index: 1; text-align: right; }
        .stat-box { background: rgba(255,255,255,0.03); padding: 8px 15px; border-radius: 6px; border-left: 2px solid #333; }
        .stat-label { font-size: 0.75rem; color: #666; display: block; text-transform: uppercase; }
        .stat-val { font-size: 1rem; color: #ddd; font-weight: 500; font-family: monospace; }

        /* BUTTON */
        .btn-wrapper { text-align: center; margin-bottom: 25px; }
        #btn-start {
            padding: 12px 50px; background: linear-gradient(90deg, #2962ff, #1565c0); /* Biru Profesional */
            color: white; border: none; border-radius: 50px; font-size: 1rem; font-weight: bold; letter-spacing: 1px;
            cursor: pointer; box-shadow: 0 0 20px rgba(41, 98, 255, 0.3); transition: all 0.3s;
        }
        #btn-start:hover { transform: translateY(-2px); box-shadow: 0 5px 25px rgba(41, 98, 255, 0.5); }
        #btn-start:disabled { background: #333; box-shadow: none; cursor: default; transform: none; color: #777; }

        /* PROGRESS */
        #loading-container { width: 100%; max-width: 900px; margin: 0 auto 10px auto; display: none; }
        #loading-text { text-align: center; margin-bottom: 5px; color: #666; font-size: 0.8em; }
        #progress-bg { width: 100%; background: #222; height: 4px; border-radius: 2px; overflow: hidden; }
        #progress-bar { width: 0%; height: 100%; background: #4caf50; transition: width 0.3s; }

        /* TABLE */
        table { width: 100%; max-width: 1400px; margin: 0 auto; border-collapse: collapse; font-size: 0.85em; background: #111; border-radius: 8px; overflow: hidden; }
        th { 
            background: #1a1d21; padding: 15px 10px; text-align: center; position: sticky; top: 0; 
            border-bottom: 2px solid #2a2e35; color: #777; text-transform: uppercase; letter-spacing: 0.5px; font-weight: 600;
        }
        td { padding: 12px 10px; border-bottom: 1px solid #1a1d21; transition: background 0.2s; text-align: center; color: #ccc; }
        tr:hover { background: #16191c; }
        
        th:nth-child(1), td:nth-child(1) { text-align: left; padding-left: 20px; font-weight: 600; color: #fff; width: 8%; } 
        th:nth-child(2), td:nth-child(2) { text-align: right; font-family: 'Consolas', monospace; color: #eee; width: 8%; }
        
        /* KOLOM BARU KHUSUS SMC */
        th:nth-child(5) { width: 15%; background: #1c1515; border-bottom: 2px solid #ff1744; color: #ff5252; font-weight: 800; } /* SMC SETUP */
        
        .sym-cell { cursor: pointer; transition: color 0.2s; }
        .sym-cell:hover { color: #2196F3; text-decoration: underline; }

        .det-symbol { font-size: 1.2em; cursor: help; }
        .prep-symbol { font-size: 1.2em; cursor: help; text-shadow: 0 0 5px rgba(255,255,255,0.4); }

        /* SMC BADGES */
        .smc-sweep { 
            background: #b71c1c; color: #fff; padding: 5px 10px; border-radius: 4px; 
            font-weight: 800; border: 1px solid #ff5252; text-transform: uppercase;
            box-shadow: 0 0 10px rgba(255, 23, 68, 0.3); letter-spacing: 0.5px;
            animation: pulse-red 1s infinite;
        }
        .smc-none { color: #333; font-size: 0.8em; }

        /* PATTERN BADGES */
        .pat-hs { color: #fff; background: #3e2723; padding: 4px 8px; border-radius: 4px; font-weight: bold; border: 1px solid #795548; }
        .pat-dt { color: #000; background: #ffeb3b; padding: 4px 8px; border-radius: 4px; font-weight: bold; border: 1px solid #fbc02d; }
        .pat-flag { color: #fff; background: #4a148c; padding: 4px 8px; border-radius: 4px; font-weight: bold; border: 1px solid #ea80fc; }
        .pat-none { color: #333; font-size: 0.8em; }

        .rek-buy { background: rgba(0, 230, 118, 0.15); color: #69f0ae; border: 1px solid #00e676; padding: 5px 10px; border-radius: 4px; font-weight: bold; display: inline-block; }
        .rek-sell { background: rgba(255, 23, 68, 0.15); color: #ff5252; border: 1px solid #ff1744; padding: 5px 10px; border-radius: 4px; font-weight: bold; display: inline-block; }
        .rek-dom-sell { background: #b71c1c; color: #fff; border: 1px solid #ff1744; padding: 5px 10px; border-radius: 4px; font-weight: 800; text-transform: uppercase; animation: pulse-red 1.5s infinite; }
        .rek-dom-buy { background: #1b5e20; color: #fff; border: 1px solid #00e676; padding: 5px 10px; border-radius: 4px; font-weight: 800; text-transform: uppercase; animation: pulse-green 1.5s infinite; }
        .rek-careful { color: #ff9800; font-weight: bold; }
        .rek-no { color: #444; }

        .tr-strong-up { color: #00e676; font-weight: bold; }
        .tr-up { color: #69f0ae; }
        .tr-strong-down { color: #ff1744; font-weight: bold; }
        .tr-down { color: #ff5252; }
        .tr-side { color: #666; }

        .badge { display: inline-block; padding: 2px 6px; border-radius: 3px; font-size: 0.75em; font-weight: 600; min-width: 45px; }
        .st-hit-up { background: #1b5e20; color: #a5d6a7; }
        .st-hit-down { background: #b71c1c; color: #ef9a9a; }
        .st-near-up { color: #ffeb3b; } 
        .st-near-down { color: #ff9800; }
        .st-normal { color: #333; }

        .c-up { color: #00e676; } .c-down { color: #ff1744; } .c-gray { color: #666; }

        @keyframes pulse-red { 0% { box-shadow: 0 0 0 0 rgba(255, 82, 82, 0.7); } 70% { box-shadow: 0 0 0 10px rgba(255, 82, 82, 0); } 100% { box-shadow: 0 0 0 0 rgba(255, 82, 82, 0); } }
        @keyframes pulse-green { 0% { box-shadow: 0 0 0 0 rgba(0, 230, 118, 0.7); } 70% { box-shadow: 0 0 0 10px rgba(0, 230, 118, 0); } 100% { box-shadow: 0 0 0 0 rgba(0, 230, 118, 0); } }
        @keyframes float { 0% { transform: translateY(0px); } 50% { transform: translateY(-10px); } 100% { transform: translateY(0px); } }

        #toast {
            visibility: hidden; min-width: 200px; margin-left: -100px; background-color: #222; color: #fff;
            text-align: center; border-radius: 50px; padding: 12px; position: fixed; z-index: 1000; left: 50%; bottom: 30px;
            font-size: 14px; border: 1px solid #444; box-shadow: 0 5px 15px rgba(0,0,0,0.5);
        }
        #toast.show { visibility: visible; animation: fadein 0.5s, fadeout 0.5s 2.5s; }
        @keyframes fadein { from {bottom: 0; opacity: 0;} to {bottom: 30px; opacity: 1;} }
        @keyframes fadeout { from {bottom: 30px; opacity: 1;} to {bottom: 0; opacity: 0;} }
    </style>
</head>
<body>

    <h1>BingX SMC Sniper Pro</h1>
    <div class="config-info">Mode: Liquidity Sweep & Displacement Scanner | Timeframe: 1H</div>
    
    <div class="btc-hero">
        <div class="hero-left">
            <img src="https://cryptologos.cc/logos/bitcoin-btc-logo.svg?v=026" class="btc-logo" alt="BTC">
            <div class="btc-price-group">
                <h2>BITCOIN (USDT)</h2>
                <h1 id="btc-hero-price">00,000.00</h1>
                <div id="btc-hero-change" class="btc-change">0.00%</div>
            </div>
        </div>
        <div class="hero-right">
            <div class="stat-box">
                <span class="stat-label">24h High</span>
                <span class="stat-val" id="btc-hero-high">-</span>
            </div>
            <div class="stat-box">
                <span class="stat-label">24h Low</span>
                <span class="stat-val" id="btc-hero-low">-</span>
            </div>
            <div class="stat-box">
                <span class="stat-label">Volume (USDT)</span>
                <span class="stat-val" id="btc-hero-vol">-</span>
            </div>
            <div class="stat-box">
                <span class="stat-label">Status</span>
                <span class="stat-val" id="btc-hero-status" style="font-size: 0.8em">WAITING</span>
            </div>
        </div>
    </div>

    <div class="update-info" id="update-indicator">Waiting to Start...</div>

    <div class="btn-wrapper">
        <button id="btn-start" onclick="startApp()">▶️ ACTIVATE SMC ALGO</button>
    </div>

    <div id="loading-container">
        <div id="loading-text">Initializing System...</div>
        <div id="progress-bg"><div id="progress-bar"></div></div>
    </div>

    <table id="main-table">
        <thead>
            <tr>
                <th>Symbol</th>
                <th>Price</th>
                <th>AI Signal</th>
                <th>Pattern</th>
                <th>SMC SETUP</th> <th>Detect</th>
                <th>Trend 1H</th>
                <th>Vol 4H</th>
                <th>15M</th>
                <th>30M</th>
                <th>1H</th>
                <th>4H</th>
            </tr>
        </thead>
        <tbody id="table-body"></tbody>
    </table>

    <div id="toast">Copied!</div>

    <script>
        const CONFIG = { TARGET: 5.0, NEAR: 0.4 };
        const API_TICKER = "?action=ticker";
        const API_HISTORY = "?action=history";
        
        let db = {};
        let isRunning = false;
        const TIMEFRAMES = ['15m', '30m', '1h', '4h'];

        // --- UTILS ---
        function formatMoney(num) { return parseFloat(num).toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2}); }
        function formatVol(num) {
            if (!num) return "-";
            if (num >= 1000000000) return (num / 1000000000).toFixed(2) + 'B';
            if (num >= 1000000) return (num / 1000000).toFixed(2) + 'M';
            if (num >= 1000) return (num / 1000).toFixed(0) + 'K';
            return num.toFixed(0);
        }
        function copySymbol(rawSymbol) {
            const cleanSymbol = rawSymbol.replace("-", "");
            navigator.clipboard.writeText(cleanSymbol).then(() => showToast("Copied: " + cleanSymbol));
        }
        function showToast(msg) {
            var x = document.getElementById("toast");
            x.innerText = msg; x.className = "show";
            setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
        }
        
        function updateLastUpdate() {
            const now = new Date();
            const dot = now.getSeconds() % 2 === 0 ? "🔴" : "⚪"; 
            document.getElementById('update-indicator').innerHTML = `${dot} LIVE SMC SCANNER | Updated: <span style="color:#fff; font-weight:bold">${now.toLocaleTimeString()}</span>`;
        }

        // --- DASHBOARD ---
        function updateBtcHero(data) {
            const price = parseFloat(data.lastPrice);
            const chg = parseFloat(data.priceChangePercent);
            
            const elPrice = document.getElementById('btc-hero-price');
            const elChg = document.getElementById('btc-hero-change');
            
            elPrice.innerText = formatMoney(price);
            elPrice.style.color = chg >= 0 ? '#00e676' : '#ff1744';

            elChg.innerText = (chg >= 0 ? "+" : "") + chg.toFixed(2) + "%";
            elChg.style.backgroundColor = chg >= 0 ? 'rgba(0, 230, 118, 0.2)' : 'rgba(255, 23, 68, 0.2)';
            elChg.style.color = chg >= 0 ? '#00e676' : '#ff1744';

            document.getElementById('btc-hero-high').innerText = formatMoney(data.highPrice);
            document.getElementById('btc-hero-low').innerText = formatMoney(data.lowPrice);
            document.getElementById('btc-hero-vol').innerText = formatVol(data.quoteVolume);
            
            const elStatus = document.getElementById('btc-hero-status');
            if(chg > 3) { elStatus.innerText = "STRONG BULL"; elStatus.style.color = "#00e676"; }
            else if(chg < -3) { elStatus.innerText = "DOMINANT SELL"; elStatus.style.color = "#ff1744"; }
            else { elStatus.innerText = "NORMAL"; elStatus.style.color = "#ccc"; }
        }

        // --- CORE ENGINE ---
        async function startApp() {
            if(isRunning) return;
            const btn = document.getElementById('btn-start');
            btn.disabled = true;
            btn.innerText = "INITIALIZING AI...";
            isRunning = true;

            setStatus("Scanning Market...");
            await fetchTickers(true);

            document.getElementById('loading-container').style.display = 'block';
            for (const tf of TIMEFRAMES) {
                await fetchHistoryForTF(tf);
            }

            setStatus("✅ SYSTEM ONLINE");
            document.getElementById('progress-bar').style.background = "#2962ff";
            btn.innerText = "SMC ALGO ACTIVE";
            
            setInterval(() => fetchTickers(false), 3000);
        }

        async function fetchTickers(firstRun) {
            try {
                const url = API_TICKER + "&_t=" + new Date().getTime();
                const res = await fetch(url);
                const json = await res.json();
                
                if(json.code !== 0) return;

                json.data.forEach(c => {
                    if(c.symbol === "BTC-USDT") updateBtcHero(c);

                    if(c.symbol.endsWith("-USDT")) {
                        const sym = c.symbol;
                        const p = parseFloat(c.lastPrice);
                        const v = parseFloat(c.quoteVolume);
                        
                        if(!db[sym]) {
                            db[sym] = { 
                                sym: sym, price: p, volume: v, 
                                volChg4h: 0, trend1h: '-', trendClass: '',
                                reco: {text:'-', class:'rek-no', score:0},
                                detect: {text:'-', title:'None', class:'det-none'},
                                smc: {text: '-', class: 'smc-none', score: 0}, // NEW SMC OBJECT
                                structure: {type: 'none', score: 0},
                                pattern: {text: '-', class: 'pat-none'}
                            };
                            TIMEFRAMES.forEach(tf => db[sym][tf] = { close: null, status: '...' });
                        } else {
                            db[sym].price = p;
                            db[sym].volume = v;
                        }

                        TIMEFRAMES.forEach(tf => { if(db[sym][tf].close) calcStatus(db[sym], tf); });
                        
                        if(db[sym]['1h'].close) {
                            calcDetection(db[sym]); 
                        }
                        
                        calcRecommendation(db[sym]);
                    }
                });

                updateLastUpdate(); 
                if(firstRun) renderTable();
                else updateUI(); 
            } catch(e) { console.error("Network/API Error:", e); }
        }

        async function fetchHistoryForTF(tf) {
            const symbols = Object.keys(db);
            const total = symbols.length;
            const batchSize = 10;
            
            for(let i=0; i<total; i+=batchSize) {
                const batch = symbols.slice(i, i+batchSize);
                await Promise.all(batch.map(async (sym) => {
                    try {
                        const url = `${API_HISTORY}&symbol=${sym}&interval=${tf}&_t=${new Date().getTime()}`;
                        const res = await fetch(url);
                        const json = await res.json();
                        
                        if(json.code === 0 && json.data && json.data.length >= 2) {
                            const klines = json.data;
                            const lastComplete = klines[klines.length-2];
                            const closeVal = parseFloat(lastComplete.close);
                            db[sym][tf].close = closeVal;

                            if (tf === '4h' && klines.length >= 3) {
                                const getVol = (k) => parseFloat(k.v || k.vol || k.volume || 0);
                                const volLast = getVol(lastComplete); 
                                const volPrev = getVol(klines[klines.length-3]); 
                                if (volPrev > 0) db[sym].volChg4h = ((volLast - volPrev) / volPrev) * 100;
                            }

                            if (tf === '1h' && klines.length >= 20) {
                                calcTrend1H(db[sym], klines);
                                const curr = klines[klines.length-1];
                                db[sym].curHigh = parseFloat(curr.high);
                                db[sym].curLow = parseFloat(curr.low);
                                
                                // LOGIKA PENTING DITARUH DISINI
                                calcPattern1H(db[sym], klines);
                                calcSMC(db[sym], klines); // PANGGIL FUNGSI GENIUS DISINI
                                calcDetection(db[sym]);
                            }
                            
                            calcStatus(db[sym], tf);
                            calcRecommendation(db[sym]);
                        }
                    } catch(e) {}
                }));

                const progress = ((TIMEFRAMES.indexOf(tf) * total) + i + batchSize) / (TIMEFRAMES.length * total) * 100;
                document.getElementById('progress-bar').style.width = progress + "%";
                setStatus(`Analyzing Smart Money Logic ${tf.toUpperCase()} (${i}/${total})...`);
                if(i % 50 === 0) renderTable(); 
                await new Promise(r => setTimeout(r, 100));
            }
            renderTable();
        }

        // --- ALGORITMA GENIUS TRADER (SMC LIQUIDITY SWEEP) ---
        // Mencari: Raid High Sebelumnya + Close dibawah High tsb (Sweep) + MSB/Displacement
        function calcSMC(item, klines) {
            // Kita butuh minimal 20 candle terakhir
            const len = klines.length;
            if(len < 20) return;

            // Candle Terakhir Selesai (Signal Candle)
            const c1 = klines[len-2]; 
            const c1_high = parseFloat(c1.high);
            const c1_low = parseFloat(c1.low);
            const c1_open = parseFloat(c1.open);
            const c1_close = parseFloat(c1.close);

            // Candle Sebelumnya (Pre-Signal)
            const c2 = klines[len-3];
            const c2_high = parseFloat(c2.high);
            const c2_low = parseFloat(c2.low);

            // 1. CARI LIQUIDITY SWEEP (RAID)
            // Mencari High tertinggi dari 10 candle sebelum signal candle (Candle 3 s/d 13)
            let liquidityHigh = 0;
            for(let i=3; i<=13; i++) {
                const h = parseFloat(klines[len-i].high);
                if(h > liquidityHigh) liquidityHigh = h;
            }

            // LOGIKA RAIDER:
            // a. Signal Candle (c1) High-nya menjebol Liquidity High
            const isSweep = c1_high > liquidityHigh;

            // b. TAPI, Closenya kembali di bawah Liquidity High (Gagal Breakout/Fakeout)
            const isFakeout = c1_close < liquidityHigh;

            // c. Candle harus MERAH (Bearish) - Menandakan rejection kuat
            const isBearish = c1_close < c1_open;

            // 2. MARKET STRUCTURE BREAK (MICRO) & DISPLACEMENT
            // Validasi V-Shape: Close candle signal (c1) harus memakan low candle sebelumnya (c2) atau setidaknya menutup sangat rendah
            // Opsi A: Engulfing (Body c1 menutup di bawah Low c2) -> Sangat Kuat
            const msb = c1_close < c2_low;
            
            // Opsi B: Displacement (Body candle besar, wick bawah kecil)
            const bodySize = Math.abs(c1_close - c1_open);
            const totalSize = c1_high - c1_low;
            const displacement = (bodySize / totalSize) > 0.6; // Body minimal 60% dari range

            // --- EKSEKUSI SINYAL ---
            if (isSweep && isFakeout && isBearish) {
                if (msb) {
                    // RAID + MSB = PERFECT ENTRY
                    item.smc = { text: "SWEEP & MSB 🩸", class: "smc-sweep", score: -50 };
                    return;
                } else if (displacement) {
                    // RAID + DISPLACEMENT
                    item.smc = { text: "LIQ SWEEP 🩸", class: "smc-sweep", score: -30 };
                    return;
                }
            }

            // Jika tidak ada setup
            item.smc = { text: "-", class: "smc-none", score: 0 };
        }

        // --- PATTERN CLASSIC (Tetap dipertahankan) ---
        function calcPattern1H(item, klines) {
            if(klines.length < 25) return; 

            let highs = [], lows = [], opens = [], closes = [];
            for(let i=klines.length-2; i>=klines.length-27; i--) {
                highs.push(parseFloat(klines[i].high));
                lows.push(parseFloat(klines[i].low));
                opens.push(parseFloat(klines[i].open));
                closes.push(parseFloat(klines[i].close));
            }
            const currentPrice = item.price; 

            // DOUBLE TOP
            const max1 = Math.max(...highs.slice(1, 6)); 
            const max2 = Math.max(...highs.slice(8, 16)); 
            const neckline = Math.min(...lows.slice(4, 10)); 
            const diff = Math.abs(max1 - max2) / max1; 
            
            if (diff < 0.015 && neckline < max1 * 0.98) { 
                if (currentPrice < neckline) { 
                    item.pattern = { text: "M (Break)", class: "pat-dt" };
                    return;
                }
            }

            // BEAR FLAG
            const pOld = highs[15];
            const pBase = lows[5];
            const pFlagLow = lows[1]; 
            const poleDrop = (pOld - pBase) / pOld; 
            if (poleDrop > 0.04) { 
                if (currentPrice < pFlagLow) { 
                    item.pattern = { text: "Bear Flag", class: "pat-flag" };
                    return;
                }
            }

            item.pattern = { text: "-", class: "pat-none" };
        }

        function calcRecommendation(item) {
            let score = 0;
            let triggers = { up: 0, down: 0 };
            
            if (item.trendClass === 'tr-strong-up') score += 2;
            else if (item.trendClass === 'tr-strong-down') score -= 2;

            TIMEFRAMES.forEach(tf => {
                const s = item[tf].status;
                if (s.includes("HIT UP") || s.includes("NEAR UP")) triggers.up++;
                if (s.includes("HIT DOWN") || s.includes("NEAR DOWN")) triggers.down++;
            });

            if (item.detect.text === "🟢") score += 2;
            if (item.detect.text === "🔴") score -= 2;

            // SMC SCORE - SUPERIOR WEIGHT
            score += item.smc.score; // Ini poin paling besar (-30 atau -50)

            if (item.pattern.text.includes("M")) score -= 10; 
            if (item.pattern.text.includes("Flag")) score -= 8; 

            const volPump = item.volChg4h > 30;   
            let text = "WAIT";
            let cls = "rek-no";
            let sortScore = 0;

            // LOGIKA REKOMENDASI DIPERBAHARUI UNTUK SMC
            if (item.smc.score < 0) {
                 text = "SMC SHORT 🩸"; cls = "rek-dom-sell"; sortScore = 500; // Prioritas Tertinggi
            }
            else if (score <= -8 || item.pattern.text !== '-') {
                if(item.pattern.text !== '-') { text = "PATTERN SELL"; cls = "rek-sell"; sortScore = 300; }
                else if (volPump) { text = "PANIC SELL"; cls = "rek-sell"; sortScore = 150; } 
                else { text = "STRONG SHORT"; cls = "rek-sell"; sortScore = 120; }
            }
            else if (score >= 4) {
                 text = "LONG"; cls = "rek-buy"; sortScore = 100;
            }
            else {
                 text = "NO SETUP"; cls = "rek-no"; sortScore = 0;
            }

            item.reco = { text: text, class: cls, score: sortScore };
        }

        function calcDetection(item) {
            if(!item.sma5 || !item.curLow) return;
            const p = item.price;
            const sma = item.sma5;
            const low = item.curLow;
            const high = item.curHigh;

            if (p > sma && low < sma) { item.detect = { text: "🟢", title: "Reject Support", class:'' }; }
            else if (p < sma && high > sma) { item.detect = { text: "🔴", title: "Reject Resist", class:'' }; }
            else { item.detect = { text: "-", title: "None", class:'det-none' }; }
        }

        function calcTrend1H(item, klines) {
            let sum = 0; 
            const endIndex = klines.length - 2; 
            for(let j=0; j<5; j++) sum += parseFloat(klines[endIndex - j].close);
            const sma5 = sum / 5;
            const prevHigh = parseFloat(klines[endIndex].high);
            const prevLow = parseFloat(klines[endIndex].low);
            item.sma5 = sma5; item.prevHigh = prevHigh; item.prevLow = prevLow;
            
            const p = item.price;
            if (p > item.sma5) { item.trend1h = "UP"; item.trendClass = "tr-up"; } 
            else if (p < item.sma5) { item.trend1h = "DOWN"; item.trendClass = "tr-down"; } 
            else { item.trend1h = "SIDE"; item.trendClass = "tr-side"; }
        }

        function calcStatus(item, tf) {
            const hist = item[tf];
            if(!hist || !hist.close) return;
            const close = hist.close;
            const price = item.price;
            const tPct = CONFIG.TARGET / 100;
            const nPct = CONFIG.NEAR / 100;
            const up = close * (1 + tPct);
            const down = close * (1 - tPct);

            if (price >= up) hist.status = "HIT UP";
            else if (price >= up * (1 - nPct)) hist.status = "NEAR UP";
            else if (price <= down) hist.status = "HIT DOWN";
            else if (price <= down * (1 + nPct)) hist.status = "NEAR DOWN";
            else hist.status = "-";
        }

        function renderTable() {
            const tbody = document.getElementById('table-body');
            // Sort berdasarkan Score SMC tertinggi dulu
            const keys = Object.keys(db).sort((a,b) => db[b].reco.score - db[a].reco.score);

            let html = "";
            keys.forEach(key => {
                const d = db[key];
                const badge = (tf) => {
                    const s = d[tf].status;
                    let cls = "st-normal";
                    if(s.includes("HIT UP")) cls = "st-hit-up";
                    else if(s.includes("HIT DOWN")) cls = "st-hit-down";
                    else if(s.includes("NEAR UP")) cls = "st-near-up";
                    else if(s.includes("NEAR DOWN")) cls = "st-near-down";
                    return s !== '-' ? `<span class="badge ${cls}">${s.replace('HIT ', '').replace('NEAR ', 'NR ')}</span>` : '<span style="color:#333">-</span>';
                };

                html += `<tr id="row-${d.sym}">
                    <td class="sym-cell" onclick="copySymbol('${d.sym}')">${d.sym}</td>
                    <td id="p-${d.sym}">${d.price}</td>
                    <td id="rec-${d.sym}"><span class="${d.reco.class}">${d.reco.text}</span></td>
                    <td id="pat-${d.sym}"><span class="${d.pattern.class}">${d.pattern.text}</span></td>
                    
                    <td id="smc-${d.sym}"><span class="${d.smc.class}">${d.smc.text}</span></td>
                    
                    <td id="det-${d.sym}"><span class="det-symbol">${d.detect.text}</span></td>
                    <td id="tr-${d.sym}"><span class="${d.trendClass}">${d.trend1h}</span></td>
                    <td id="vd-${d.sym}">${d.volChg4h !== 0 ? d.volChg4h.toFixed(1)+'%' : '-'}</td>
                    <td id="b15-${d.sym}">${badge('15m')}</td>
                    <td id="b30-${d.sym}">${badge('30m')}</td>
                    <td id="b1h-${d.sym}">${badge('1h')}</td>
                    <td id="b4h-${d.sym}">${badge('4h')}</td>
                </tr>`;
            });
            tbody.innerHTML = html;
        }

        function updateUI() {
            Object.values(db).forEach(d => {
                const elP = document.getElementById(`p-${d.sym}`);
                if(elP && elP.innerText != d.price) elP.innerText = d.price;

                const elRec = document.getElementById(`rec-${d.sym}`);
                if (elRec && elRec.innerText !== d.reco.text) elRec.innerHTML = `<span class="${d.reco.class}">${d.reco.text}</span>`;
                
                const elSmc = document.getElementById(`smc-${d.sym}`);
                if (elSmc && elSmc.innerText !== d.smc.text) elSmc.innerHTML = `<span class="${d.smc.class}">${d.smc.text}</span>`;

                const elPat = document.getElementById(`pat-${d.sym}`);
                if (elPat && elPat.innerText !== d.pattern.text) elPat.innerHTML = `<span class="${d.pattern.class}">${d.pattern.text}</span>`;
            });
        }

        function setStatus(msg) { document.getElementById('loading-text').innerText = msg; }
    </script>
</body>
</html>