<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // Hapus jika sudah di production
header("Access-Control-Allow-Headers: Content-Type");

// 1. Koneksi Database (Sesuaikan dengan settingan Anda)
$host = 'localhost';
$dbname = 'hdoxsbgb_email'; // GANTI INI
$username = 'hdoxsbgb_mail';             // GANTI INI
$password = 'Semangat45..'; 

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'msg' => 'Database connection failed: ' . $e->getMessage()]);
    exit;
}

// 2. Ambil Data JSON dari Body Request
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Validasi input
if (!isset($input['emails']) || !is_array($input['emails']) || empty($input['emails'])) {
    echo json_encode(['ok' => false, 'msg' => 'Tidak ada email yang dipilih.']);
    exit;
}

$emails = $input['emails'];
$days = isset($input['days']) ? intval($input['days']) : 30; // Default 30 hari

try {
    // 3. Siapkan Query UPDATE
    // Kita menggunakan placeholder (?) sejumlah email yang dikirim untuk klausa IN (...)
    $placeholders = str_repeat('?,', count($emails) - 1) . '?';
    
    // LOGIKA: 
    // - Set 'Non Aktif' = Tanggal Non Aktif sebelumnya DITAMBAH durasi ($days)
    // - Set 'Status' = 'active' (jaga-jaga jika status sebelumnya expired/hapus)
    // - Pastikan nama kolom 'Non Aktif' / 'NonAktif' sesuai tabel Anda. Di sini saya pakai `NonAktif`.
    
    // GANTI `NonAktif` dengan nama kolom di database Anda jika berbeda (misal `non_aktif`)
    $sql = "UPDATE email 
            SET `Non Aktif` = DATE_ADD(`Non Aktif`, INTERVAL $days DAY),
                `Status` = 'active'
            WHERE `Email` IN ($placeholders)";

    $stmt = $pdo->prepare($sql);
    
    // Eksekusi query dengan array email
    $stmt->execute($emails);

    $rowCount = $stmt->rowCount();

    echo json_encode([
        'ok' => true,
        'count' => $rowCount,
        'msg' => "Berhasil memperpanjang $rowCount email."
    ]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'msg' => 'Query Error: ' . $e->getMessage()]);
}
?>