<?php
// list-emails.php
// Gunakan untuk mengambil daftar email dari tabel jbcybmaq_email
// Params (GET):
// - search (optional) : pencarian substring di kolom Email
// - onlyExpired (0|1) : jika 1, hanya kembalikan baris yang Non Aktif < today
// - limit (optional) : max row (default 200)
// - offset (optional)


// CONFIG - sesuaikan sebelum pakai
$DB_HOST = '127.0.0.1';
$DB_NAME = 'hdoxsbgb_email';
$DB_USER = 'hdoxsbgb_mail';
$DB_PASS = 'Semangat45..';
// jika ingin memakai API key, isi nilai berikut dan kirim header X-API-Key
$API_KEY = null; // mis: 'my-secret-key'

// ----- CORS (sesuaikan production) -----
if (isset($_SERVER['HTTP_ORIGIN'])) {
header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key');
}
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
header('Access-Control-Allow-Methods: GET, OPTIONS');
http_response_code(200);
exit;
}
header('Content-Type: application/json; charset=utf-8');


// optional API key check
if ($API_KEY !== null) {
$sent = $_SERVER['HTTP_X_API_KEY'] ?? null;
if ($sent !== $API_KEY) {
http_response_code(401);
echo json_encode(['ok' => false, 'msg' => 'Unauthorized (invalid API key)']);
exit;
}
}


$search = trim($_GET['search'] ?? '');
$onlyExpired = (isset($_GET['onlyExpired']) && $_GET['onlyExpired'] === '1') ? 1 : 0;
$limit = intval($_GET['limit'] ?? 50000);
if ($limit <= 0 || $limit > 200000) $limit = 50000;
$offset = intval($_GET['offset'] ?? 0);


$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_errno) {
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => 'DB connect error: ' . $mysqli->connect_error]);
exit;
}
$mysqli->set_charset('utf8mb4');


// build query
$sql = "SELECT Email, Aktif, `Non Aktif`, COALESCE(Status, '') AS Status FROM email WHERE 1=1";
$params = [];
$types = '';


if ($search !== '') {
$sql .= " AND (Email LIKE CONCAT('%', ?, '%'))";
$params[] = $search;
$types .= 's';
}


if ($onlyExpired) {
// ensure non-empty and date comparison
$sql .= " AND `Non Aktif` IS NOT NULL AND `Non Aktif` <> '' AND DATE(`Non Aktif`) < CURDATE()";
}


$sql .= " ORDER BY `Non Aktif` ASC, Email ASC LIMIT ? OFFSET ?";
$params[] = $limit;
$params[] = $offset;
$types .= 'ii';

$stmt = $mysqli->prepare($sql);
if (!$stmt) {
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => 'Prepare failed: ' . $mysqli->error]);
exit;
}


if (!empty($params)) {
// bind params dynamically
$bind_names[] = $types;
for ($i=0;$i<count($params);$i++) {
$bind_name = 'bind' . $i;
$$bind_name = $params[$i];
$bind_names[] = &$$bind_name;
}
call_user_func_array([$stmt, 'bind_param'], $bind_names);
}


if (!$stmt->execute()) {
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => 'Execute failed: ' . $stmt->error]);
exit;
}


$res = $stmt->get_result();
$rows = [];
while ($r = $res->fetch_assoc()) {
$rows[] = $r;
}


echo json_encode(['ok' => true, 'rows' => $rows]);