<?php
// save-emails.php
// Simpan daftar email ke database jbcybmaq_email

// --- Izinkan akses CORS (agar bisa dipanggil dari browser) ---
if (isset($_SERVER['HTTP_ORIGIN'])) {
  header("Access-Control-Allow-Origin: " . $_SERVER['HTTP_ORIGIN']);
  header('Access-Control-Allow-Credentials: true');
  header('Access-Control-Allow-Headers: Content-Type, X-API-Key');
}
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  header('Access-Control-Allow-Methods: POST, OPTIONS');
  http_response_code(200);
  exit;
}

header('Content-Type: application/json; charset=utf-8');

// --- Baca JSON dari body ---
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (json_last_error() !== JSON_ERROR_NONE) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'Invalid JSON']);
  exit;
}
if (!$data || !isset($data['emails']) || !is_array($data['emails'])) {
  http_response_code(400);
  echo json_encode(['ok' => false, 'msg' => 'Missing emails array']);
  exit;
}

// --- Konfigurasi koneksi database ---
$host = '127.0.0.1';
$db = 'hdoxsbgb_email';
$user = 'hdoxsbgb_mail';
$pass = 'Semangat45..';
$mysqli = new mysqli($host, $user, $pass, $db);
if ($mysqli->connect_errno) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'msg' => 'DB connect error: ' . $mysqli->connect_error]);
  exit;
}
$mysqli->set_charset('utf8mb4');

// --- Siapkan query ---
$sql = "INSERT INTO email (Email, Aktif, `Non Aktif`)
        VALUES (?, ?, ?)
        ON DUPLICATE KEY UPDATE Aktif=VALUES(Aktif), `Non Aktif`=VALUES(`Non Aktif`)";
$stmt = $mysqli->prepare($sql);
if (!$stmt) {
  http_response_code(500);
  echo json_encode(['ok' => false, 'msg' => 'Prepare failed: ' . $mysqli->error]);
  exit;
}

// --- Jalankan penyimpanan ---
$mysqli->begin_transaction();
$inserted = 0;
try {
  foreach ($data['emails'] as $row) {
    $email = $row['Email'] ?? '';
    $aktif = $row['Aktif'] ?? '';
    $non   = $row['NonAktif'] ?? '';

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) continue;

    $stmt->bind_param('sss', $email, $aktif, $non);
    $stmt->execute();
    $inserted++;
  }
  $mysqli->commit();
  echo json_encode(['ok' => true, 'count' => $inserted]);
} catch (Exception $e) {
  $mysqli->rollback();
  http_response_code(500);
  echo json_encode(['ok' => false, 'msg' => $e->getMessage()]);
}
?>
