<?php
$DB_HOST = '127.0.0.1';
$DB_NAME = 'hdoxsbgb_email';
$DB_USER = 'hdoxsbgb_mail';
$DB_PASS = 'Semangat45..';
$API_KEY = null; // set jika ingin proteksi


// CORS
if (isset($_SERVER['HTTP_ORIGIN'])) {
header('Access-Control-Allow-Origin: ' . $_SERVER['HTTP_ORIGIN']);
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Headers: Content-Type, X-API-Key');
}
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
header('Access-Control-Allow-Methods: POST, OPTIONS');
http_response_code(200);
exit;
}
header('Content-Type: application/json; charset=utf-8');


// optional API key
if ($API_KEY !== null) {
$sent = $_SERVER['HTTP_X_API_KEY'] ?? null;
if ($sent !== $API_KEY) {
http_response_code(401);
echo json_encode(['ok' => false, 'msg' => 'Unauthorized (invalid API key)']);
exit;
}
}


$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (json_last_error() !== JSON_ERROR_NONE) {
http_response_code(400);
echo json_encode(['ok' => false, 'msg' => 'Invalid JSON: ' . json_last_error_msg()]);
exit;
}


if (!$data || !isset($data['emails']) || !is_array($data['emails']) || !isset($data['status'])) {
http_response_code(400);
echo json_encode(['ok' => false, 'msg' => 'Invalid payload']);
exit;
}


$emails = array_values(array_filter(array_map('trim', $data['emails'])));
$status = trim($data['status']);
if (!$status) {
http_response_code(400);
echo json_encode(['ok' => false, 'msg' => 'Invalid status']);
exit;
}


$mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_errno) {
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => 'DB connect error: ' . $mysqli->connect_error]);
exit;
}
$mysqli->set_charset('utf8mb4');


// Use prepared statement per-email to avoid complex IN-binding; this is safe and simple.
$sql = "UPDATE email SET Status = ? WHERE Email = ?";
$stmt = $mysqli->prepare($sql);
if (!$stmt) {
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => 'Prepare failed: ' . $mysqli->error]);
exit;
}


$mysqli->begin_transaction();
$updated = 0;
try {
foreach ($emails as $em) {
if (!filter_var($em, FILTER_VALIDATE_EMAIL)) continue;
$stmt->bind_param('ss', $status, $em);
if (!$stmt->execute()) throw new Exception('Execute failed: ' . $stmt->error);
$updated += $stmt->affected_rows >= 0 ? max(0, $stmt->affected_rows) : 0;
}
$mysqli->commit();
echo json_encode(['ok' => true, 'count' => $updated]);
} catch (Exception $e) {
$mysqli->rollback();
http_response_code(500);
echo json_encode(['ok' => false, 'msg' => $e->getMessage()]);
}